<?php

class Sender extends Plugin
{
	var $author = "Dmitri Lebedev (detail)";
	var $title = "Extension functions for connection";
	var $ver = "1.0";
	
	function sendText($text, $time = 0)
	{
		//A quick function to make LFS say a "typed" message.
		$this->conn->sendPacket(pack("CCCCa95C", 100, ISP_MSX, 0, 0, $text, 0), $time, false);
	}
	
	function localText($text, $time = 0)
	{
		$this->conn->sendPacket(pack("CCCCa127C", 132, ISP_MSL, 0, SND_MESSAGE, $text, 0), $time, false);
	}
	
	function sendTextToConn($text, $connId)
	{
		// Sends a direct message to a connection. Not viewed by other users.
		$this->conn->sendPacket(pack("CCCCCCCCa63C", 72, ISP_MTC, 0, 0, $connId, 0, 0, 0, $text, 0));
	}
	
	function sendCommand($text)
	{
		// Sends control command to LFS. Not visible by others in multiplayer.
		$text = preg_replace("~^/?~", "/", $text);
		$this->conn->sendPacket(pack("CCCCa63C", 68, ISP_MST, 0, 0, $text, 0));
	}
	
	function sendButton($connId, $clickId, $inst, $bstyle, $typeIn, $L, $T, $W, $H, $text)
	{
		// Sends a button. Here all the co-ordinates are automatically squished into the ranges [IS_X_MIN, IS_X_MAX] and [IS_Y_MIN, IS_Y_MAX], that are advised by Scawen (in InSim.txt)
		$L = maxMin(IS_X_MAX, IS_X_MIN, $L);
		$W = maxMin(IS_X_MAX - $L, 0, $W);
		$T = maxMin(IS_Y_MAX, IS_Y_MIN, $T);
		$H = maxMin(IS_Y_MAX - $T, 0, $H);
		
		$pack = pack("CCCCCCCCCCa240", ISP_BTN, $clickId, $connId, $inst, $bstyle, $typeIn,
		$L, $T, $W, $H, $text);
		
		$size = intval(ceil((strlen($pack)+1)/4)*4);
		
		$this->conn->sendPacket(pack("C", $size). str_pad($pack, $size-1, "\x00"));
	}
}